Ext.BLANK_IMAGE_URL = './lib/ext/resources/images/default/s.gif';

Ext.onReady(function() {
    // NCbN`bvX̏
    Ext.QuickTips.init();

    // f[^[
    var gpxTrack = [
        ['2008-10-04 09:54:06',35.371586,136.643680],
        ['2008-10-04 09:54:09',35.371583,136.643082],
        ['2008-10-04 00:54:12',35.371700,136.642497]
    ];

    var store = new Ext.data.SimpleStore({
		fields: [
          {name: 'time', type: 'date', dateFormat: 'Y-m-d H:i:s'},
          {name: 'lat', type: 'float'},
          {name: 'lon', type: 'float'}
		],
        data: gpxTrack
    });

    var colModel = new Ext.grid.ColumnModel([
        {id:'time',header: 'time', width: 140, sortable: true, renderer: Ext.util.Format.dateRenderer('Y/m/d H:i:s'), dataIndex: 'time'},
        {header: 'lat', align: 'right', width: 80, sortable: true, dataIndex: 'lat'},
        {header: 'lon', align: 'right', width: 80, sortable: true, dataIndex: 'lon'}
    ]);

    var grid = new Ext.grid.GridPanel({
        store: store,
        cm: colModel,
        stripeRows: true,
        title:'GPX Data',
		region: 'center'
    });

    var panel = new Ext.Panel({
        title : 'panel_sample',
        width: 200,
		split: true,
        collapsible: true,
        region: 'west'
    });
    var viewport = new Ext.Viewport({
        layout:'border',
        items:[
          panel,
          grid
        ]
    });
    // Loading...폜
    setTimeout(function(){
        Ext.get('loading').remove();
        Ext.get('loading-mask').fadeOut({remove:true});
    }, 500);

});

